package gov.va.vamf.scheduling.direct.domain;

import com.agilex.healthcare.veteranappointment.domain.Namespace;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;


@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@JsonIgnoreProperties({"empty"})
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.DirectScheduling)
public class SiteSupportingVARs extends DomainBaseObjects<SiteSupportingVAR> {

    @XmlElement(namespace = Namespace.DirectScheduling)
    public Collection<SiteSupportingVAR> getSitesSupportingVAR() {
        List<SiteSupportingVAR> list = new ArrayList<SiteSupportingVAR>();
        for (SiteSupportingVAR siteSupportingVAR : this) {
            list.add(siteSupportingVAR);
        }
        return list;
    }
}
